@extends('layouts.instructor')
@push('title', get_phrase('edit book'))


@section('content')
    <div class="row mb-5">
        <div class="col-lg-12">
            <div class="ol-card radius-8px">
                <div class="ol-card-body my-3 py-4 px-20px">
                    <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                        <h4 class="title fs-16px">
                            <i class="fi-rr-settings-sliders me-2"></i>
                            {{ get_phrase('Add new book') }}
                        </h4>
                    </div>
                </div>
            </div>
            <div class="ol-card p-3">
                <div class="ol-card-body">
                    <form action="{{ route('instructor.ebook.update', $ebook_details->id) }}" method="post"
                        enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="ebook_type" value="general" required>
                        <input type="hidden" name="instructors[]" value="{{ auth()->user()->id }}" required>
                        <div class="row">
                            <div class="col-md-6 pb-2">
                                <div class="eForm-layouts">
                                    <div class="fpb-7 mb-3">
                                        <label class="form-label ol-form-label"
                                            for="title">{{ get_phrase('Title') }}<span
                                                class="text-danger ms-1">*</span></label>
                                        <input type="text" name = "title" class="form-control ol-form-control"
                                            value="{{ $ebook_details->title }}"
                                            placeholder="{{ get_phrase('Enter Title') }}" required>
                                    </div>
                                    <div class="fpb-7 mb-3">
                                        <div class="fpb-7 mb-3">
                                            <label for="category_id"
                                                class="form-label ol-form-label">{{ get_phrase('Category') }}<span
                                                    class="text-danger ms-1">*</span></label>
                                            <select class="ol-select2" name="category_id" id="category_id" required>
                                                <option value="">{{ get_phrase('Select a category') }}</option>
                                                @foreach ($category as $category)
                                                    <option
                                                        value="{{ $category->id }}"@if ($ebook_details->category_id == $category->id) selected @endif>
                                                        {{ $category->title }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="fpb-7 mb-3">
                                        <div class="fpb-7 mb-3">
                                            <label for="language_id"
                                                class="form-label ol-form-label">{{ get_phrase('language') }}<span
                                                    class="text-danger ms-1">*</span></label>
                                            <select class="ol-select2" name="language_id" id="language_id" required>
                                                <option value="">{{ get_phrase('Select a language') }}</option>
                                                @foreach ($language as $language)
                                                    <option value="{{ $language->id }}"
                                                        @if ($ebook_details->language_id == $language->id) selected @endif>
                                                        {{ $language->name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="fpb-7 mb-3">
                                        <label class="form-label ol-form-label"
                                            for="description">{{ get_phrase('Description') }}</label>
                                        <textarea name="description" placeholder="{{ get_phrase('Enter Description') }}"
                                            class="form-control ol-form-control text_editor">{!! $ebook_details->description !!}</textarea>
                                    </div>
                                    <div class="fpb-7 mb-3">
                                        <label class="form-label ol-form-label" for="summary">{{ get_phrase('Summary ') }}
                                        </label>
                                        <textarea name="summary" placeholder="{{ get_phrase('Enter Summary') }}" class="form-control ol-form-control"
                                            rows="5">{{ $ebook_details->summary }}</textarea>
                                    </div>
                                    <div class="fpb-7 mb-3">
                                        <label class="form-label ol-form-label"
                                            for="publication_name">{{ get_phrase('Publication name') }}</label>
                                        <input type="text" name = "publication_name" class="form-control ol-form-control"
                                            value="{{ $ebook_details->publication_name }}"
                                            placeholder="{{ get_phrase('Enter Publication name') }}" required>
                                    </div>
                                    <div class="fpb-7 mb-3">
                                        <label class="form-label ol-form-label"
                                            for="edition">{{ get_phrase('Edition') }}</label>
                                        <input type="text" name = "edition" class="form-control ol-form-control"
                                            value="{{ $ebook_details->edition }}"
                                            placeholder="{{ get_phrase('Enter Edition') }}" required>
                                    </div>

                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="eForm-layouts">
                                    <div class="fpb-7 mb-3">
                                        <label
                                            class="form-label ol-form-label col-sm-2 col-form-label">{{ get_phrase('Pricing type') }}<span
                                                class="text-danger ms-1">*</span></label>

                                        <div class="eRadios">
                                            <div class="form-check">
                                                <input type="radio" name="is_paid" value="{{ $ebook_details->is_paid }}"
                                                    class="form-check-input eRadioSuccess" id="paid"
                                                    onchange="$('#paid-section').slideDown(200)" checked>
                                                <label for="paid"
                                                    class="form-check-label">{{ get_phrase('Paid') }}</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="radio" name="is_paid" value="{{ $ebook_details->is_paid }}"
                                                    class="form-check-input eRadioSuccess" id="free"
                                                    onchange="$('#paid-section').slideUp(200)">
                                                <label for="free"
                                                    class="form-check-label">{{ get_phrase('Free') }}</label>
                                            </div>
                                            <div class="paid-section" id="paid-section">
                                                <div class="fpb-7 mb-3">
                                                    <label for="price"
                                                        class="form-label ol-form-label">{{ get_phrase('Price') }}
                                                        <small>({{ currency() }})</small><span
                                                            class="text-danger ms-1">*</span></label>

                                                    <input type="number" name="price"
                                                        class="form-control ol-form-control" id="price"
                                                        min="1" step=".01"
                                                        value="{{ $ebook_details->price }}"
                                                        placeholder="{{ get_phrase('Enter your course price') }} ({{ currency() }})">
                                                </div>

                                                <div class="fpb-7 mb-3">
                                                    <div class="form-check">
                                                        <input type="checkbox" name="discount_flag" value="1"
                                                            class="form-check-input eRadioSuccess" id="discount_flag"
                                                            {{ $ebook_details->discount_flag == '1' ? 'checked' : '' }}>
                                                        <label for="discount_flag"
                                                            class="form-check-label">{{ get_phrase('Check if this ebook has discount') }}</label>
                                                    </div>
                                                </div>

                                                <div class="fpb-7 mb-3">
                                                    <label for="discounted_price"
                                                        class="form-label ol-form-label">{{ get_phrase('Discounted price') }}</label>

                                                    <input type="number" name="discounted_price"
                                                        class="form-control ol-form-control" id="discounted_price"
                                                        value="{{ $ebook_details->discounted_price }}" min="1"
                                                        step=".01"
                                                        placeholder="{{ get_phrase('Enter your discount price') }} ({{ currency() }})">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="fpb-7 mb-3">
                                    <label class="form-label ol-form-label"
                                        for="published_date">{{ get_phrase('Published Date') }}</label>
                                    <input type="date" name="published_date" class="form-control ol-form-control"
                                        value="{{ date('Y-m-d', $ebook_details->published_date) }}" required>
                                </div>
                                <div class="fpb-7 mb-3">
                                    <label for="thumbnail"
                                        class="form-label ol-form-label">{{ get_phrase('Thumbnail') }}</label><span
                                        class="text-danger ms-1">*</span>
                                    <input type="file" name="thumbnail" class="form-control ol-form-control"
                                        value="{{ $ebook_details->thumbnail }}" id="thumbnail" accept="image/*" />
                                </div>
                                <div class="fpb-7 mb-3">
                                    <label for="preview"
                                        class="form-label ol-form-label">{{ get_phrase('Ebook preview file') }}<span
                                            class="text-danger ms-1">*</span></label>
                                    <input type="file" name="preview" class="form-control ol-form-control"
                                        value="{{ $ebook_details->preview }}" id="preview" />
                                </div>
                                <div class="fpb-7 mb-3">
                                    <label for="complete"
                                        class="form-label ol-form-label">{{ get_phrase('Ebook complete file') }}<span
                                            class="text-danger ms-1">*</span></label>
                                    <input type="file" name="complete" class="form-control ol-form-control"
                                        value="{{ $ebook_details->complete }}" id="complete" />
                                </div>
                            </div>
                            <div class="pt-2">
                                <button type="submit"
                                    class="btn ol-btn-primary float-end">{{ get_phrase('Submit') }}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script>
        "Use strict";

        //Start progress
        var totalSteps = $('#v-pills-tab .nav-link').length
        var progressVal = 100 / totalSteps;
        $(function() {
            var pValPerItem = progressVal;
            $('#courseFormProgress .progress-bar').attr('aria-valuemin', 0);
            $('#courseFormProgress .progress-bar').attr('aria-valuemax', pValPerItem);
            $('#courseFormProgress .progress-bar').attr('aria-valuenow', pValPerItem);
            $('#courseFormProgress .progress-bar').width(pValPerItem + '%');
            $('#courseFormProgress .progress-bar').text("Step 1 out of " + totalSteps);
        });

        $("#v-pills-tab .nav-link").click(function() {
            var currentStep = $("#v-pills-tab .nav-link").index(this) + 1;
            var pValPerItem = currentStep * progressVal;
            $('#courseFormProgress .progress-bar').attr('aria-valuemin', 0);
            $('#courseFormProgress .progress-bar').attr('aria-valuemax', pValPerItem);
            $('#courseFormProgress .progress-bar').attr('aria-valuenow', pValPerItem);
            $('#courseFormProgress .progress-bar').width(pValPerItem + '%');
            $('#courseFormProgress .progress-bar').text("Step " + currentStep + " out of " + totalSteps);

            if (currentStep == totalSteps) {
                $('#courseFormProgress .progress-bar').text("{{ get_phrase('Finish!') }}");
                $('#courseFormProgress .progress-bar').addClass('bg-success');
            } else {
                $('#courseFormProgress .progress-bar').removeClass('bg-success');
            }
        });
        //End progress
    </script>
@endpush
