<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Illuminate\View\View;

class ConfirmablePasswordController extends Controller
{
    /**
     * Show the confirm password view.
     */
    public function show(): View
    {
        return view('auth.confirm-password');
    }

    /**
     * Confirm the user's password.
     */
    public function store(Request $request): RedirectResponse
    {
        if (!Auth::guard('web')->validate([
            'email' => $request->user()->email,
            'password' => $request->password,
        ])) {
            throw ValidationException::withMessages([
                'password' => __('auth.password'),
            ]);
        }

        $request->session()->put('auth.password_confirmed_at', time());

        // return redirect()->intended('/'.$request->segment(1).RouteServiceProvider::HOME);
        $company_slug = $request->segment(1);

        if (
            empty($company_slug) || 
            in_array($company_slug, ['login', 'logout', 'register', 'client', 'superadmin'])
        ) {
            return redirect()->intended(RouteServiceProvider::HOME);
        } else {
            return redirect()->intended('/' . $company_slug . RouteServiceProvider::HOME);
        }
    }
}
