<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;

class EmailVerificationPromptController extends Controller
{
    /**
     * Display the email verification prompt.
     */
    public function __invoke(Request $request): RedirectResponse|View
{
    $company_slug = $request->segment(1);

    if (
        empty($company_slug) || 
        in_array($company_slug, ['login', 'logout', 'register', 'client', 'superadmin'])
    ) {
        return $request->user()->hasVerifiedEmail()
            ? redirect()->intended(RouteServiceProvider::HOME)
            : view('auth.verify-email');
    } else {
        return $request->user()->hasVerifiedEmail()
            ? redirect()->intended('/' . $company_slug . RouteServiceProvider::HOME)
            : view('auth.verify-email');
    }
}

}
