@extends('layouts.superadmin')

@push('title', get_phrase('Packages'))

@push('meta')
@endpush

@push('css')
@endpush

@section('content')
    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-12px px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-settings-sliders me-2"></i>
                    {{ get_phrase('All Packages') }} <span class="text-muted">({{ $packages->count() }})</span>
                </h4>

                <a onclick="ajaxModal('{{ route('modal', 'superadmin.package.create')}}', '{{ get_phrase('Add new Package') }}')" href="#" class="btn ol-btn-outline-secondary d-flex align-items-center cg-10px">
                    <span class="fi-rr-plus"></span>
                    <span>{{ get_phrase('Add new Package') }}</span>
                </a>
            </div>
        </div>
    </div>

<div class="row">
    <div class="col-12">
        <div class="ol-card">
            <div class="ol-card-body p-3">
                <div class="row print-d-none mb-3 mt-3 row-gap-3">
                    <div class="col-md-6 pt-2 pt-md-0">
                        <div class="custom-dropdown">
                            <button class="dropdown-header btn ol-btn-light">
                                {{ get_phrase('Export') }}
                                <i class="fi-rr-file-export ms-2"></i>
                            </button>
                            <ul class="dropdown-list">
                                <li>
                                    <a class="dropdown-item" href="#" onclick="downloadPDF('.print-table', 'package-list')"><i class="fi-rr-file-pdf"></i> {{ get_phrase('PDF') }}</a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="#" onclick="window.print();"><i class="fi-rr-print"></i> {{ get_phrase('Print') }}</a>
                                </li>
                            </ul>
                        </div>
                    </div>

                    <div class="col-md-6 mt-3 mt-md-0">
                        <form action="{{ route('superadmin.package.index') }}" method="get" class="d-flex gap-3 justify-content-end">
                            <div class="search-input flex-grow-1">
                                <input type="text" name="search" value="{{ request('search') }}" placeholder="{{ get_phrase('Search Package') }}" class="ol-form-control form-control" />

                            </div>
                            <button type="submit" class="btn ol-btn-primary" id="submit-button">{{ get_phrase('Search') }}</button>
                        </form>
                    </div>
                </div>
                <!-- Table -->
                @if (count($packages) > 0)
                    <div class="superadmin-tInfo-pagi d-flex justify-content-between justify-content-center align-items-center flex-wrap gr-15">
                        <p class="superadmin-tInfo">
                            {{ get_phrase('Showing') . ' ' . count($packages) . ' ' . get_phrase('of') . ' ' . $packages->total() . ' ' . get_phrase('data') }}
                        </p>
                    </div>
                    <div class="table-responsive course_list" id="course_list">
                        <table class="table eTable eTable-2 print-table">
                            <thead>
                                <tr>
                                    <th scope="col">#</th>
                                    <th  scope="col">{{ get_phrase('Package Name') }}</th>
                                    <th  scope="col">{{ get_phrase('Price') }}</th>
                                    <th  scope="col">{{ get_phrase('Interval') }}</th>
                                    <th  scope="col">{{ get_phrase('duration') }}</th>
                                    <th  scope="col">{{ get_phrase('Features') }}</th>
                                    <th  scope="col">{{ get_phrase('Status') }}</th>
                                    <th  scope="col"  class="print-d-none">{{ get_phrase('Options') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($packages as $key => $package)
                                    <tr>
                                        <th scope="row">
                                            <p class="row-number">{{ ++$key }}</p>
                                        </th>

                                        <td>
                                            <div class="dsuperadmin_profile d-flex align-items-center min-w-200px">
                                                <div class="dsuperadmin_profile_name">
                                                    <h4 class="title fs-14px">{{ $package->title }}</h4>
                                                </div>
                                            </div>
                                        </td>

                                        <td>
                                            <div class="dsuperadmin_info_name min-w-150px">
                                                <p>
                                                    {{ currency($package->price, 2) }}
                                                </p>
                                            </div>
                                        </td>

                                        <td>
                                            <div class="dsuperadmin_info_name min-w-150px">
                                                {{ ucfirst($package->interval) }}
                                            </div>
                                        </td>
                                        <td>
                                            <div class="dsuperadmin_info_name min-w-150px">
                                                {{ ucfirst($package->interval_preiod) }}
                                            </div>
                                        </td>

                                        <td style="max-width: 250px;">
                                            @php
                                                $features = $package->features ? json_decode($package->features, true) : [];
                                            @endphp
                                            @if(count($features))
                                                <ul class="list-unstyled small mb-0">
                                                    @foreach($features as $feature)
                                                        <li><i class="bi bi-check-circle text-success"></i> {{ $feature }}</li>
                                                    @endforeach
                                                </ul>
                                            @else
                                                <span class="text-muted">{{ get_phrase('No features added') }}</span>
                                            @endif
                                        </td>

                                        <td>
                                            <div class="dsuperadmin_info_name min-w-150px">
                                                <p> @if($package->status == 1)
                                                    <span class="badge bg-success">{{ get_phrase('Active') }}</span>
                                                @else
                                                    <span class="badge bg-secondary">{{ get_phrase('Inactive') }}</span>
                                                @endif</p>
                                                
                                            </div>
                                        </td>

                                        <td class="print-d-none">
                                            <div class="dropdown ol-icon-dropdown ol-icon-dropdown-transparent">
                                                <button class="btn ol-btn-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                    <span class="fi-rr-menu-dots-vertical"></span>
                                                </button>
                                                <ul class="dropdown-menu">
                                                    
                                                    <li>
                                                        <a class="dropdown-item" href="javascript:void(0);" 
                                                        onclick="ajaxModal('{{ route('superadmin.package.edit', ['id' => $package->id]) }}', '{{ get_phrase('Edit Package') }}')">
                                                        {{ get_phrase('Edit') }}
                                                        </a>
                                                    </li>
                                                    <li><a class="dropdown-item" href="javascript:void(0);" onclick="confirmModal('{{ route('superadmin.package.delete', ['id' => $package->id]) }}')">{{ get_phrase('Delete') }}</a></li>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    @include('superadmin.no_data')
                @endif
                <!-- Data info and Pagination -->
                @if (count($packages) > 0)
                    <div class="superadmin-tInfo-pagi d-flex justify-content-between justify-content-center align-items-center flex-wrap gr-15">
                        <p class="superadmin-tInfo">
                            {{ get_phrase('Showing') . ' ' . count($packages) . ' ' . get_phrase('of') . ' ' . $packages->total() . ' ' . get_phrase('data') }}
                        </p>
                        {{ $packages->links() }}
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
 
@endsection
