<div class="sidebar">
    <div class="row mb-4">
        <div class="col-6">
            <?php echo e(get_phrase('Filter')); ?>

        </div>
        <div class="col-6 text-end">
            <?php if(count(request()->all()) > 0 || !empty($category_details)): ?>
                <a href="<?php echo e(route('ebooks')); ?>"><?php echo e(get_phrase('Clear')); ?></a>
            <?php endif; ?>
        </div>
    </div>
    <form class="mb-4" action="<?php echo e(route('ebooks')); ?>" method="get">
        <div class="widget">
            <div class="search">
                <input type="text" class="form-control" name="search" placeholder="<?php echo e(get_phrase('Search...')); ?>"
                    <?php if(request()->has('search')): ?> value="<?php echo e(request()->input('search')); ?>" <?php endif; ?>>
                <button type="submit" class="submit"><i class="fa-solid fa-magnifying-glass"></i></button>
            </div>
        </div>
    </form>

    <!------------------- categories start ------------------->
    <div class="widget">
    <h4 class="widget-title"><?php echo e(get_phrase('Categories')); ?></h4>
    <ul class="entry-widget" id="parent-category">
        <?php
            $parent_categories = App\Models\EbookCategory::get();
            $active_category = request()->route()->parameter('category');
            $route_queries = request()->query();
            $route_queries = collect($route_queries)->except('page')->all();
        ?>

        <?php $__currentLoopData = $parent_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $parent_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php $route_queries['category'] = $parent_category->slug; ?>

            <li class="category <?php if($parent_category->slug == $active_category): ?> active <?php endif; ?> 
                <?php echo e($index >= 6 ? 'extra-category d-none' : ''); ?>" 
                id="<?php echo e($parent_category->slug); ?>">
                <a href="<?php echo e(route('ebooks', $route_queries)); ?>"
                    class="d-flex align-items-center justify-content-between">
                    <span><?php echo e($parent_category->title); ?></span>
                    <span><?php echo e(\App\Models\Ebook::where('category_id', $parent_category->id)->count()); ?></span>
                </a>
            </li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>

    <?php if($parent_categories->count() > 6): ?>
        <div class="down-text toggle-category" style="cursor: pointer;">
            <?php echo e(get_phrase('Show More')); ?>

        </div>
    <?php endif; ?>
</div>

    <!------------------- categories end ------------------->

    <form action="<?php echo e(route('ebooks', request()->route()->parameter('category'))); ?>" method="get" id="filter-courses">

        <?php if(request()->has('search')): ?>
            <input type="hidden" name="search" value="<?php echo e(request()->input('search')); ?>">
        <?php endif; ?>


        <!------------------- price filter start ------------------->
        <div class="widget">
            <h4 class="widget-title"><?php echo e(get_phrase('Price')); ?></h4>
            <ul class="entry-widget">
                <?php $__currentLoopData = ['paid', 'discount', 'free']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="filter-item">
                        <div class="form-check">
                            <input class="form-check-input mt-0" type="radio" name="price"
                                value="<?php echo e($price); ?>" id="price-<?php echo e($price); ?>"
                                <?php if(request()->has('price') && request()->input('price') == $price): ?> checked <?php endif; ?> />
                            <label class="form-check-label"
                                for="price-<?php echo e($price); ?>"><?php echo e(get_phrase(ucfirst($price))); ?></label>
                        </div>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>

        <!------------------- price filter end ------------------->

        <!------------------- ratings start ------------------->
        <div class="widget">
            <h4 class="widget-title"><?php echo e(get_phrase('Ratings')); ?></h4>
            <ul class="entry-widget">
                <?php for($i = 5; $i >= 1; $i--): ?>
                    <li class="form-check">
                        <input class="form-check-input" type="radio" name="rating" value="<?php echo e($i); ?>"
                            id="raging-<?php echo e($i); ?>" <?php if(request()->has('rating') && request()->input('rating') == $i): ?> checked <?php endif; ?> />
                        <label class="form-check-label" for="raging-<?php echo e($i); ?>">
                            <ul class="d-flex g-star g-5">
                                <?php for($j = 1; $j <= 5; $j++): ?>
                                    <li <?php if($j <= $i): ?> class="color-g" <?php endif; ?>>
                                        <i class="fa fa-star"></i>
                                    </li>
                                <?php endfor; ?>
                            </ul>
                        </label>
                    </li>
                <?php endfor; ?>


            </ul>
        </div>
        <!------------------- ratings end ------------------->
    </form>
</div>


<?php $__env->startPush('js'); ?>
    <script>
        $(document).ready(function() {
            $('#see-more').click(function(e) {
                e.preventDefault();
                $(this).toggleClass('active');
                let show_more = $(this).html();

                if ($(this).hasClass('active')) {
                    $('#parent-category').css('height', 'auto');
                    $(this).css('margin-top', '20px');
                    $(this).text('<?php echo e(get_phrase('Show Less')); ?>');
                } else {
                    $('#parent-category').css('height', '400px');
                    $(this).css('margin-top', '0px');
                    $(this).html('<?php echo e(get_phrase('Show More')); ?>');
                }
            });

            var scrollTop = $(".scrollTop");
            $(scrollTop).click(function() {
                $('html, body').animate({
                    scrollTop: 0
                }, 100);
                return false;
            });

            $('input[type="radio"]').change(function(e) {
                $('#filter-courses').submit();
            });
        });
    </script>


<script>
    document.addEventListener("DOMContentLoaded", function () {
        const toggleBtn = document.querySelector('.toggle-category');
        const extraItems = document.querySelectorAll('.extra-category');
        let expanded = false;

        if (toggleBtn) {
            toggleBtn.addEventListener('click', function () {
                extraItems.forEach(item => item.classList.toggle('d-none'));
                expanded = !expanded;
                toggleBtn.textContent = expanded ? "<?php echo e(get_phrase('Show Less')); ?>" : "<?php echo e(get_phrase('Show More')); ?>";
            });
        }
    });
</script>


<?php $__env->stopPush(); ?>
<?php /**PATH C:\MAMP\htdocs\academy_lms_sass\academy\resources\views/frontend/default/ebooks/filter.blade.php ENDPATH**/ ?>