
<?php $__env->startPush('title', get_phrase('Dashboard')); ?>
<?php $__env->startPush('meta'); ?><?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<style>
    /* Gradient Button */
    .btn-gradient {
        background: linear-gradient(135deg, #4f46e5, #9333ea);
        color: #fff;
        border: none;
        transition: all 0.3s ease;
    }
    .btn-gradient:hover {
        opacity: 0.9;
        transform: translateY(-2px);
        box-shadow: 0 8px 20px rgba(0,0,0,0.15);
        color: #fff;
    }
    /* Card Hover Effect */
    .package-card {
        transition: transform 0.35s ease, box-shadow 0.35s ease;
    }
    .package-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 12px 30px rgba(0,0,0,0.15);
    }
    /* Feature icon size tweak */
    .package-card i {
        font-size: 1.2rem;
    }
    span.billing_cycle {
        font-size: 14px;
        font-style: oblique;
    }
    .price_section {
        font-size: 10px !important;
        top: -9px;
        position: absolute;
        right: -4px;
    }
</style>
<div class="ol-card radius-8px">
    <div class="ol-card-body my-3 py-12px px-20px">
        <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
            <h4 class="title fs-16px">
                <i class="fi-rr-settings-sliders me-2"></i>
                <?php echo e(get_phrase('All Packages')); ?> <span class="text-muted">(<?php echo e($packages->count()); ?>)</span>
            </h4>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="ol-card border-0 shadow-sm rounded-3 mb-5">
            <div class="ol-card-body p-4">
                <h2 class="fw-bold text-center mb-5"><?php echo e(get_phrase('Find the Perfect Package for You')); ?></h2>
                <div class="row g-4">
                    <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-4 col-md-6 mb-5">
                             <?php if(isset($purchasedPackageIds->id)): ?>
                                <!-- If NOT purchased → keep it clickable -->
                                <a>
                             <?php else: ?>
                                <!-- If already purchased → remove link wrapper -->
                                 <a href="<?php echo e(route('client.package.purchase', $package->id)); ?>">
                                
                             <?php endif; ?>
                                    <div class="card h-100 border-0 rounded-4 shadow-lg package-card overflow-hidden position-relative">
                                        <!-- Card Header with Gradient -->
                                        <div class="p-4 text-white text-center package-header" 
                                            style="background: linear-gradient(135deg, #4f46e5, #9333ea);">
                                            <h4 class="fw-bold mb-2"><?php echo e(ucfirst($package->title)); ?></h4>
                                            <p class="small mb-0"><?php echo e(Str::limit($package->description, 60)); ?></p>
                                        </div>

                                        <!-- Price Section (Glassmorphism) -->
                                        <div class="price_section m-3 bg-white bg-opacity-25 text-white px-3 py-1 rounded-pill shadow-sm"
                                            style="backdrop-filter: blur(8px);">
                                            <?php echo e(($package->interval_preiod)); ?> <span>
                                                <?php if($package->interval === 'monthly'): ?>
                                                    <?php echo e(get_phrase('Month')); ?>

                                                <?php elseif($package->interval === 'yearly'): ?>
                                                    <?php echo e(get_phrase('Year')); ?>

                                                <?php elseif($package->interval === 'weekly'): ?>
                                                    <?php echo e(get_phrase('Week')); ?>

                                                <?php else: ?>
                                                    <?php echo e(get_phrase('Duration')); ?>

                                                <?php endif; ?>
                                            </span>

                                        </div>

                                        <!-- Card Body -->
                                        <div class="card-body d-flex flex-column p-4">
                                            <h5 class="text-center fw-bold mb-4">
                                                <?php echo e(currency($package->price, 2)); ?> / <span class="billing_cycle"><?php echo e(ucfirst($package->interval)); ?></span>
                                            </h5>

                                            <!-- Features List -->
                                            <ul class="list-unstyled flex-grow-1">
                                                <?php
                                                    $features = $package->features ? json_decode($package->features, true) : [];
                                                ?>

                                                <?php if(count($features)): ?>
                                                    <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li class="mb-3 d-flex align-items-center">
                                                            <i style="font-size: 12px;" class="fas fa-check-circle text-success me-2"></i>
                                                            <span><?php echo e($feature); ?></span>
                                                        </li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </ul>

                                            <!-- Buy Button -->
                                            <div class="text-center mt-auto">
                                                <?php if(isset($purchasedPackageIds->id)): ?>
                                                <a href="#"
                                                class="btn btn-gradient rounded-pill px-4 py-2 fw-semibold shadow-sm" disabled style="font-size: 14px;">
                                                <?php echo e(get_phrase('Allready active a package')); ?>

                                                </a>
                                                <?php else: ?>
                                                <a href="<?php echo e(route('client.package.purchase', $package->id)); ?>"
                                                class="btn btn-gradient rounded-pill px-4 py-2 fw-semibold shadow-sm" style="font-size: 14px;">
                                                <?php echo e(get_phrase('Buy Now')); ?>

                                                </a>
                                                <?php endif; ?>
                                            </div>

                                        </div>
                                    </div>            
                                </a>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.client', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\MAMP\htdocs\academy_lms_sass\academy\resources\views/client/package/index.blade.php ENDPATH**/ ?>